---
Difficulty: Easy  
Source: Daily-Question (POTD 1-Dec)  
Tags:
- Array
- Hash Table
- Two Pointers
- Binary Search
- Sorting
---

# 🚀 *1346 - Check If N and Its Double Exist* 🧠

### Problem Link:
[**LeetCode - Check If N and Its Double Exist**](https://leetcode.com/problems/check-if-n-and-its-double-exist/description/?envType=daily-question&envId=2024-12-01)

## 💡 **Problem Breakdown:**

Given an array `arr` of integers, we need to check if there exist two indices `i` and `j` such that:

- `i != j`
- `0 <= i, j < arr.length`
- `arr[i] == 2 * arr[j]`

The goal is to determine whether there are two elements in the array such that one element is double the value of the other.

## 🔍 **Example Walkthrough:**

### Example 1:

**Input:**  
`arr = [10, 2, 5, 3]`

**Output:**  
`true`

**Explanation:**  
For `i = 0` and `j = 2`, `arr[i] == 10` and `arr[j] == 5`, which satisfies `arr[i] == 2 * arr[j]`.

### Example 2:

**Input:**  
`arr = [3, 1, 7, 11]`

**Output:**  
`false`

**Explanation:**  
There is no pair `i` and `j` where `arr[i] == 2 * arr[j]`.

### Constraints:
- `2 <= arr.length <= 500`
- $`-10^3 <= arr[i] <= 10^3`$



## 🎯 **My Approach:**

We can approach this problem using **sorting and binary search** to check for pairs satisfying the condition.

### 1. **Sort the Array**:  
   - Sorting the array helps us quickly find whether an element's double exists later in the array.

### 2. **Binary Search for Each Element**:  
   - For each element `arr[i]`, we calculate its double `2 * arr[i]`.
   - We use binary search to check if this double exists in the array after the current index `i`. This ensures that `i != j`.

### 3. **Edge Cases**:  
   - If `arr[i]` is `0`, its double will also be `0`. We need to make sure that `i != j`, so we handle this special case with careful binary search.
   - If no such pair is found, return `false`.



## 🕒 **Time Complexity:**

- **Time Complexity:**  
  - Sorting the array takes `O(n log n)`, where `n` is the number of elements in the array.
  - For each element, performing binary search on the remaining part of the array takes `O(log n)`. Thus, the overall time complexity is **O(n log n)** due to the sorting step being the most expensive operation.
  
- **Space Complexity:**  
  - The space complexity is **O(1)** since we are using in-place sorting and not requiring additional data structures that grow with the size of the input.



## 📝 **Solution Code**

## Code (C):

```c
int compare(const void* a, const void* b) {
    return (*(int*)a - *(int*)b);
}

bool checkIfExist(int* arr, int arrSize) {
    qsort(arr, arrSize, sizeof(int), compare);
    
    for (int i = 0; i < arrSize; ++i) {
        int target = 2 * arr[i];
        int left = (target >= 0 ? i + 1 : 0);
        int right = arrSize - 1;
        
        while (left <= right) {
            int mid = left + (right - left) / 2;
            if (arr[mid] == target) {
                return true;
            } else if (arr[mid] < target) {
                left = mid + 1;
            } else {
                right = mid - 1;
            }
        }
    }
    return false;
}
```

## Code (C++):

```cpp
class Solution {
public:
    bool checkIfExist(vector<int>& arr) {
        sort(arr.begin(), arr.end()); 
        
        for (int i = 0; i < arr.size(); ++i) {
            int target = arr[i] * 2;
            int left = (target >= 0 ? i + 1 : 0);
            int right = arr.size() - 1;
            
            while (left <= right) {
                int mid = left + (right - left) / 2;
                if (arr[mid] == target) {
                    return true;
                } else if (arr[mid] < target) {
                    left = mid + 1;
                } else {
                    right = mid - 1;
                }
            }
        }
        return false;
    }
};
```

## Code (Java):

```java
class Solution {
    public boolean checkIfExist(int[] arr) {
        HashSet<Integer> seen = new HashSet<>();
        
        for (int num : arr) {
            if (seen.contains(num * 2) || (num % 2 == 0 && seen.contains(num / 2))) {
                return true;
            }
            seen.add(num);
        }
        
        return false;
    }
}
```

## Code (Python):

```python
from typing import List

class Solution:
    def checkIfExist(self, arr: List[int]) -> bool:
        seen = set()
        
        for num in arr:
            if num * 2 in seen:
                return True
            if num % 2 == 0 and num // 2 in seen:
                return True
            seen.add(num)
        
        return False
```

## Code (Rust):

```rust
use std::collections::HashSet;

impl Solution {
    pub fn check_if_exist(arr: Vec<i32>) -> bool {
        let mut seen: HashSet<i32> = HashSet::new();

        for &num in &arr {
            if seen.contains(&(num * 2)) || (num % 2 == 0 && seen.contains(&(num / 2))) {
                return true;
            }
            seen.insert(num);
        }
        false
    }
}
```



## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
